﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using Windows.Gaming.Input;


namespace TestXbonePads
{
    public partial class TestForm : Form
    {
        public TestForm()
        {
            InitializeComponent();

            UpdateUI();
        }

        private void UpdateUI()
        {
            AvailableControllersLabel.Text = String.Format("Available controllers: {0}", Gamepad.Gamepads.Count);
        }

        private void ControllerUpdateTimer_Tick(object sender, EventArgs e)
        {
            UpdateUI();
        }

        private void TestRumbleButton_Click(object sender, EventArgs e)
        {
            GamepadVibration v = new GamepadVibration();
            v.LeftMotor = (float)LeftMotorUpDown.Value;
            v.LeftTrigger = (float)LeftTriggerUpDown.Value;
            v.RightMotor = (float)RightMotorUpDown.Value;
            v.RightTrigger = (float)RightTriggerUpDown.Value;

            if (Gamepad.Gamepads.Count == 0)
            {
                return;
            }

            Gamepad pad = Gamepad.Gamepads.First();
            pad.Vibration = v;


        }

        private void StopRumbleButton_Click(object sender, EventArgs e)
        {
            GamepadVibration v = new GamepadVibration();
            v.LeftMotor = 0f;
            v.LeftTrigger = 0f;
            v.RightMotor = 0f;
            v.RightTrigger = 0f;

            if (Gamepad.Gamepads.Count == 0)
            {
                return;
            }

            Gamepad pad = Gamepad.Gamepads.First();
            pad.Vibration = v;
        }
    }
}
